//
//  MCHelperBezel.h
//  MCApplication
//
//  Created by Ali Lalani on 13/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum _MCHelperBezelAnimationType {
	MCHelperBezelFadeAnimationType = 1,
	MCHelperBezelShrinkAnimationType = 2
} MCHelperBezelAnimationType;

@interface MCHelperBezel : NSView {
	// Objects
	NSColor *bgColor;
	NSAttributedString *attributedStringValue;
	NSShadow *_shadow;
	NSString *userDefaultsKey;
	NSString *_helpAnchor;
	NSAttributedString *checkboxStringValue;

	id delegate;
	
	// Primitives
	float leftMargin;
	float rightMargin;
	float topMargin;
	float bottomMargin;
	float cornerRadius;
		
	// Close button
	BOOL closeIsPressed;
	BOOL closeHasMouseOver;

	// Help button
	BOOL helpIsPressed;
	BOOL helpHasMouseOver;
	BOOL showHelpButton;

	// Checkbox button
	BOOL checkboxIsPressed;
	BOOL checkboxPressed;
	BOOL checkboxChecked;
	
	// Structs and such
	NSTrackingRectTag closeButtonTrackingRectTag;
	NSTrackingRectTag helpButtonTrackingRectTag;

	// Button rects
	NSRect closeButtonRect;
	NSRect helpButtonRect;
	NSRect topRightButtonRect;
	NSRect bottomRightButtonRect;
	NSRect stringRect;
	NSRect checkboxRect;
	NSRect checkboxStringRect;
	NSRect checkboxUnionRect;
	
	// Animation Stuff
	NSCalendarDate *animationStart;
	float animationPercentDone;
	NSTimer *animationTimer;
	NSImage *animationImage;
	NSSize sizeBeforeAnimation;
	
	float animationTotalDuration;
	
	MCHelperBezelAnimationType animationType;
}
- (void)commonInit;


// returns the preferred size of the bezel, based on margins, attributed string, etc
- (NSSize)preferredSize;

// Centers the bezel inside its superview
- (void)centerInSuperview;

// Calls the delegate should close and stuff
- (IBAction)close:(id)sender;
- (void)startAnimatingClosed;
- (IBAction)help:(id)sender;

// Resets the tracking rects for the help button and the close button
- (void)resetTrackingRects;
- (void)clearTrackingRects;

#pragma mark Accessors
- (NSColor *)bgColor;
- (void)setBgColor:(NSColor *)aBgColor;
- (NSAttributedString *)attributedStringValue;
- (void)setAttributedStringValue:(NSAttributedString *)anAttributedStringValue;
- (id)delegate;
- (void)setDelegate:(id)aDelegate;
- (float)leftMargin;
- (void)setLeftMargin:(float)aLeftMargin;
- (float)rightMargin;
- (void)setRightMargin:(float)aRightMargin;
- (float)topMargin;
- (void)setTopMargin:(float)aTopMargin;
- (float)bottomMargin;
- (void)setBottomMargin:(float)aBottomMargin;
- (float)cornerRadius;
- (void)setCornerRadius:(float)aCornerRadius;
- (NSShadow *)shadow;
- (void)setShadow:(NSShadow *)aShadow;
- (BOOL)closeIsPressed;
- (void)setCloseIsPressed:(BOOL)flag;
- (BOOL)closeHasMouseOver;
- (void)setCloseHasMouseOver:(BOOL)flag;
- (BOOL)helpIsPressed;
- (void)setHelpIsPressed:(BOOL)flag;
- (BOOL)helpHasMouseOver;
- (void)setHelpHasMouseOver:(BOOL)flag;
- (BOOL)checkboxIsPressed;
- (void)setCheckboxIsPressed:(BOOL)flag;
- (MCHelperBezelAnimationType)animationType;
- (void)setAnimationType:(MCHelperBezelAnimationType)anAnimationType;
- (BOOL)showHelpButton;
- (void)setShowHelpButton:(BOOL)flag;
- (NSString *)userDefaultsKey;
- (void)setUserDefaultsKey:(NSString *)anUserDefaultsKey;
- (NSAttributedString *)checkboxStringValue;
- (void)setCheckboxStringValue:(NSAttributedString *)aCheckboxStringValue;
- (NSString *)helpAnchor;
- (void)setHelpAnchor:(NSString *)aHelpAnchor;
@end

@interface NSObject (MCHelperBezelDelegate)
- (void)helperBezelShouldClose:(MCHelperBezel *)bezel;
- (void)helperBezelHelpButtonClicked:(MCHelperBezel *)bezel;
@end
